// File Weapon.cpp

#include <afxwin.h>
#include <stdlib.h>
#include "weapon.h"

// Definizione funzioni membro

CWeapon::CWeapon()
{
	if (!Open("Weapon.cfg", CFile::modeRead|CFile::typeText))
	{
		MessageBox(NULL, "File Weapon.cfg not found!!!!\n Program non complete!", "ERROR", MB_OK);
		SendMessage(AfxGetMainWnd()->m_hWnd, WM_CLOSE, 0, 0);
	}
	m_Size.SetSize(175);
	m_Type.SetSize(175);
	m_Damage[S_M].SetSize(200);
	m_Damage[L].SetSize(200);
}

void CWeapon::m_FillList(CComboBox& Lista)
{
	CString stringa;
	int index=0;
	Lista.ResetContent();

	while( ReadString(stringa) )
	{
		if ( stringa.GetLength()>0 && stringa[0]!=';')
		{
			int occorrenza;
			
			occorrenza=stringa.Find('\t');
			Lista.AddString(stringa.Left(occorrenza));
			stringa=stringa.Right(stringa.GetLength()-1-occorrenza);
			
			occorrenza=stringa.Find('\t');
			m_Size.SetAt(index, stringa.Left(occorrenza));
			stringa=stringa.Right(stringa.GetLength()-1-occorrenza);
			
			occorrenza=stringa.Find('\t');
			m_Type.SetAt(index, stringa.Left(occorrenza));
			stringa=stringa.Right(stringa.GetLength()-1-occorrenza);

			occorrenza=stringa.Find('\t');
			m_Damage[S_M].SetAt(index, stringa.Left(occorrenza));
			stringa=stringa.Right(stringa.GetLength()-1-occorrenza);
			
			m_Damage[L].SetAt(index++, stringa);
		}
	}
}

int CWeapon::GetSize(int index)
{
	if (!m_Size[index].Compare("S"))
		return SMALL;
	if (!m_Size[index].Compare("M"))
		return MEDIUM;
	if (!m_Size[index].Compare("L"))
		return LARGE;
	AfxGetMainWnd()->MessageBox("Tipo dell'arma non riconosciuto\n Per Default considero SMALL");
	return SMALL;
}

int CWeapon::GetTypeDamage(int index)
{
	if (!m_Type[index].Compare("B"))
		return BLUDGEONING;
	if (!m_Type[index].Compare("S"))
		return SLASHING;
	if (!m_Type[index].Compare("P"))
		return PIERCING;
	if (!m_Type[index].Compare("B/S"))
		return SLASHING;
	if (!m_Type[index].Compare("B/P"))
		return PIERCING;
	if (!m_Type[index].Compare("S/P"))
		return PIERCING;

	return BLUDGEONING;
}

void CWeapon::GetDamage(int index, int tipo, int& dado, int& bonus)
{
	CString DamageCurr = (m_Damage[tipo])[index];

	// Verifico la presenza di un dado <1d3>
	int posizione_d = DamageCurr.Find('d');
	if ( posizione_d == -1)
	{
		bonus = atoi(DamageCurr);
		dado = NODADO;
	}
	else
	{
		int posizione_p = DamageCurr.Find('+');

		// Verifico presenza di un bonus aggiuntivo
		if ( posizione_p != -1)
		{
			CString stringa = DamageCurr.Mid(posizione_d+1, posizione_p-posizione_d-1);
			dado = atoi(stringa);
			stringa = DamageCurr.Mid(posizione_p+1);
			bonus = atoi(stringa);
		}
		else
		{
			CString stringa = DamageCurr.Mid(posizione_d+1);
			dado = atoi(stringa);
			bonus=0;
		}
	}
}