// File Tools.h
// Contiene le definizioni delle classi di supporto

// Definizione delle classi per la gestione di una sequenza di tabelle multilinguaggio

// Classe di riferimento per una tabella di linguaggio
class CSingleTable
{
private:
	CStringArray m_Table;
	CSingleTable * m_NextItem;
public:
	CSingleTable() { m_NextItem = NULL; };
	~CSingleTable() { if(m_NextItem!=NULL) delete m_NextItem; };
	CSingleTable * NewTail();
	CSingleTable * NextTable() {return m_NextItem;};
	CStringArray * AccessTable() {return  & m_Table;};
};

// Classe di gestione delle multi tabelle (lista)
class CMultiTable
{
private:
	CSingleTable * m_TopList;
	CSingleTable * m_TempList;
	CStringArray * m_TempTable;
	int m_Row;
	int m_Column;
public:
	CMultiTable();
	~CMultiTable() { delete m_TopList;};
	CStringArray * GetTable(int, int);
	void Init(int);
	int NextItem(CString);
	BOOL NewTable();
	BOOL SetTable(int, int);
	CString GetItem(int);
	CString operator[](int);
	int GetColumn(){return m_Column;};
	int GetMaxElem();
	int IsInTable(CString);
	int GetNumberLanguage();
};


// Definizione della classe utilizzata per inizializzare le strutture dati di CSpellView
class CInitSpell
{
private:
	CStdioFile m_File;
	BOOL m_Error;
	BOOL FileSearch(CString);
	BOOL GetString(CString&);
public:
	CInitSpell();
	BOOL InitStruct(CStringArray &, CMultiTable &);
};