// File: Spell2.h
// Descrizione: contiene il motore di ricerca.

#include <afxdlgs.h>

class CArgSearch:public CPropertyPage
{
private:
	CComboBox * GetCast(){return (CComboBox *) GetDlgItem(IDC_CBLevel1);};
	CButton * GetButton(int ID){return (CButton*) GetDlgItem(ID);};
	void ReadLevel(CListBox *, const char *);
public:
	CStringArray *m_CasterName;
	CMultiTable *m_SchoolName;
	CString m_CasterSel;
	CIntArray m_LevelSel;
	CIntArray m_SchoolSel;
	int m_reversibile;
	CArgSearch():CPropertyPage(IDD_SPELL_SEARCH1){};
	virtual BOOL OnInitDialog();
	CListBox * GetList(int ID){return (CListBox *) GetDlgItem(ID);};
protected:
	virtual void DoDataExchange(CDataExchange*);
	afx_msg void OnCasterSet();
	afx_msg void OnAllLevel();
	afx_msg void OnClearLevel();
	afx_msg void OnAllSchool();
	afx_msg void OnClearSchool();
	afx_msg void OnSelChange();
	afx_msg void OnButtonChange();
	void SetLevelSpell(CString);
	void SetSchoolSpell(CString);
	DECLARE_MESSAGE_MAP()
};

class CStringSearch:public CPropertyPage
{
private:
public:
	CString m_GeneralString;
	CString m_RangeString;
	CString m_ComponentString;
	CString m_DurataString;
	CString m_CastingString;
	CString m_AreaString;
	CString m_SavingString;
	CStringSearch():CPropertyPage(IDD_SPELL_SEARCH2){};
protected:
	virtual void DoDataExchange(CDataExchange*);
	afx_msg void OnEditChange();
	afx_msg void OnSintaxHelp();
	DECLARE_MESSAGE_MAP()
};

class CFoundSpell:public CPropertyPage
{
private:
public:
	CString m_NameSel;
	CStringArray m_AllName;
	int m_Number;
	CFoundSpell():CPropertyPage(IDD_SPELL_SEARCH3){};
	void AddString(CString);
protected:
	virtual void DoDataExchange(CDataExchange*);
	afx_msg void OnEditChange();
};

class CSearchDialog:public CPropertySheet
{
private:
	CString m_TmpDir;
	BOOL m_ThirdPageFlag;

	BOOL SetFoundFile();
	void FillListFile(CString, int);
	BOOL SearchInFile(CStdioFile&, int);
	BOOL SearchInRow(CString, CString);
	int SeparaChiavi(CStringArray&, CString);
public:
	CArgSearch m_FirstPage;
	CStringSearch m_SecondPage;
	CFoundSpell m_ThirdPage;

	CSearchDialog(CWnd* pWnd=NULL);
protected:
	void OnApply();

	DECLARE_MESSAGE_MAP()
};