// File: Spell1.h
// Definizione delle classi per Dialogo Spell_spell
#include "tables.h"
#include "ddx_ext.h"
#include "globalview.h"

typedef struct SENDSPELL
{
	CString Caster;
	int School;
	CString Level;
	CString Name;
} DEFSPELL;

class CSpellView: public CDialog
{
	friend void CGlobalViewDialog::PostNcDestroy();

public:
	CSpellView(int mode=0);
	virtual BOOL OnInitDialog();
private:
	// configurazione
	int m_iMode;
	CGlobalViewDialog *m_pgvd;			// finestra globale view
	// variabili di stocaggio
	CString m_Caster;
	CString m_Level;
	CString m_LevelNotAll;
	int m_School;
	CString m_Spell;
	CStringArray m_CasterName;
	CMultiTable m_SchoolName;
	CString m_OldSearchCaster;
	CIntArray m_OldSearchLevel;
	CIntArray m_OldSearchSchool;
	// Manipolazione dei controlli
	CComboBox& CasterType(){return * (CComboBox *) GetDlgItem(IDC_S_TYPE);}
	CComboBox& LevelSpell(){return * (CComboBox *) GetDlgItem(IDC_S_LEVEL);}
	CComboBox& SchoolSpell(){return * (CComboBox *) GetDlgItem(IDC_S_SCHOOL);}
	CComboBox& NameSpell(){return * (CComboBox *) GetDlgItem(IDC_S_NAME);}
	CStatic& TextSpell(int value){return * (CStatic *) GetDlgItem(IDC_S_S + value);}
	CEdit& EditSpell(){return * (CEdit *) GetDlgItem(IDC_S_DESCR);}
	CButton& ViewButton(){return * (CButton *) GetDlgItem(IDC_GLOBALVIEW);};
	// Sincronizzazione dei ComboBox
	void SetLevelSpell();
	void SetSchoolSpell();
	void SetNameSpell();
	// Routine
	void DirFullName(CComboBox *, const char *, int, int);
	void DisplaySpell();
	void SetTitleBar(CString, CString);
	int WhoCast();
	void CheckName(CString&);
	void ViewSchool(CString);
protected:
	// Gestione dei controlli
	afx_msg void OnCancel();
	afx_msg void OnCasterSet();
	afx_msg void OnLevelSet();
	afx_msg void OnSchoolSet();
	afx_msg void OnNameSet();
	afx_msg void OnContextMenu(CWnd *, CPoint);
	afx_msg void OnSysCommand(UINT,LPARAM);
	afx_msg void OnSearch();
	afx_msg void OnGlobalView();
	afx_msg void OnViewSpell1(UINT, long);

	virtual void PostNcDestroy();

	DECLARE_MESSAGE_MAP()
};