// File: Roll.h
// Definizione CRollDice : dialog box per lancio dadi e Critical Hit.

#include "weapon.h"
#include "tablech.h"

class CRollDice: public CDialog
{
private:
	int m_CriticalSel;
	
	CButton& CtrlButton(int value){return * (CButton*) GetDlgItem(value);}
	CEdit *CtrlEdit(){return (CEdit*) GetDlgItem(IDC_NUMDICE);}
	CEdit& CtrlTotal(){return *(CEdit*) GetDlgItem(IDC_TOTALE);}
	CListBox *CtrlListBox(){ return(CListBox *) GetDlgItem(IDC_LIST1);}
	void m_GetDicetoRoll();

public:
	int m_DicetoRoll;
	int m_NumofDice;
	CRollDice();
	virtual BOOL OnInitDialog();
	int m_GetRandomNumber();

protected:
	afx_msg void OnVScroll( UINT, UINT, CScrollBar* );
	afx_msg void OnCriticalHit();
	afx_msg void OnCHButton();
	afx_msg void OnDiceNum();
	afx_msg void OnDiceRoll();
	afx_msg void OnDiceReset();
	void OnCancel();
	virtual void PostNcDestroy();

	DECLARE_MESSAGE_MAP()
};

class CDialogCH: public CDialog
{
private:
	int m_THACO;			// Thac0 del tiratore
	int m_AC;				// AC del bersaglio
	int m_BonusHit;			// Somma totale dei bonus per colpire
	int m_BonusDamage;		// Somma totale dei bonus danno
	int m_SavingThrowDeath;	// Valore ST del bersaglio
	int m_TargetSize;		// Dimensione del bersaglio
	int m_Weapon;			// indice del tipo di arma
	int m_LocationHit;		// genere di colpo
	int m_Target;			// Genere di bersaglio per tabella

	CWeapon m_CWeapon;
	CTableOfCritical m_TableCritical;
	CString Riga1;		// contiene danno
	CString Riga2;		// contiene locazione
	CString Riga3;		// Contiene descrizione critico

public:
	virtual BOOL OnInitDialog();
	CDialogCH(CWnd * pWnd=NULL):CDialog(IDD_ROLLDICE_CH, pWnd){}
	void m_Calculate(int);
	CString GetRiga1();
	CString GetRiga2();
	CString GetRiga3();

protected:
	afx_msg void OnSetLocation();
	virtual void DoDataExchange(CDataExchange *);
	DECLARE_MESSAGE_MAP()
};

class CDialogRollExt : public CDialog
{
public:
	int m_roll;

	CDialogRollExt(CWnd *pwnd=NULL):CDialog(IDD_ROLLDICE_CH_ROLL, pwnd){}
	virtual BOOL OnInitDialog();
private:
	virtual void DoDataExchange(CDataExchange *);
};