// File ddx_ext.cpp
//#include "ddx_ext.h"

//  classe CIntArray

CIntArray::CIntArray()
{
	m_IntArray=NULL;
	m_NumElem=0;
	m_NewElemPosit=0;
}

CIntArray::CIntArray(int numelem)
{
	m_IntArray= new int[numelem];
	m_NumElem=numelem;
	m_NewElemPosit=0;
}

CIntArray::~CIntArray()
{
	if(m_IntArray!=NULL)
		delete[] m_IntArray;
}

void CIntArray::Reset(int numelem)
{
	if(numelem<=0)
		return;
	if(m_IntArray!=NULL)
		delete[] m_IntArray;

	m_IntArray=new int[numelem];
	m_NumElem=numelem;
	m_NewElemPosit=0;
}

BOOL CIntArray::InsertAt(int pos, int elem)
{
	if(m_IntArray!=NULL && pos>=0 && pos<m_NumElem)
	{
		*(m_IntArray+pos)=elem;
		return TRUE;
	}

	return FALSE;
}

int CIntArray::GetAt(int pos)
{
	if(m_IntArray!=NULL && pos>=0 && pos<m_NumElem)
		return *(m_IntArray+pos);

	return -1;
}

int CIntArray::operator[] (int pos)
{
	return *(m_IntArray+pos);
}

void CIntArray::operator=(CIntArray *copy)
{
	int max=copy->GetSize();
	Reset(max);

	for(int cont=0; cont<max; cont++)
		AddElem(copy->GetAt(cont));
}

void CIntArray::AddElem(int elem)
{
	if(m_IntArray==NULL)
	{
		m_IntArray= new int[5];
		m_NumElem=5;
	}

	if(m_NewElemPosit==m_NumElem)
	{
		int *tmp=new int[m_NumElem+5];
		for(int cont=0; cont < m_NumElem; cont ++)
			*(tmp+cont)=*(m_IntArray+cont);
		delete[] m_IntArray;
		m_IntArray=tmp;
		m_NumElem+=5;
	}

	*(m_IntArray+m_NewElemPosit)=elem;
	m_NewElemPosit++;
}

int * CIntArray::GetArray(int num)
{
	m_NewElemPosit=num;
	return m_IntArray;
}

int CIntArray::GetSize()
{
	return m_NewElemPosit;
}

// funzione globale

void PASCAL DDX_MultiListIndex(CDataExchange *pDX, int id, CIntArray *mem)
{
	HWND HWnd=pDX->PrepareCtrl(id);
	CListBox *Lista=(CListBox*)pDX->m_pDlgWnd->GetDlgItem(id);

	if(pDX->m_bSaveAndValidate)
	{
		int max=Lista->GetSelCount();
		mem->Reset(max);
		Lista->GetSelItems(max, mem->GetArray(max));
	}
	else
	{
		for(int cont=0; cont<mem->GetSize(); cont++)
			Lista->SetSel(mem->GetAt(cont));
	}
}

void PASCAL DDX_MultiList(CDataExchange *pDX, int id, CStringArray& elenco)
{
	HWND HWnd=pDX->PrepareCtrl(id);
	CListBox *Lista=(CListBox*)pDX->m_pDlgWnd->GetDlgItem(id);

	if(pDX->m_bSaveAndValidate)
	{
		int num=Lista->GetCount();
		elenco.RemoveAll();
		for(int cont=0; cont<num; cont++)
		{
			CString tmp;
			Lista->GetText(cont, tmp);
			elenco.Add(tmp);
		}
	}
	else
	{
		for(int cont=0; cont<elenco.GetSize(); cont++)
			Lista->AddString(elenco.GetAt(cont));
	}
}