// File critical.cpp

#include <afxwin.h>
#include "resource.h"
#include "critical.h"

// Definisci message map
BEGIN_MESSAGE_MAP(CDialogCritical, CDialog)
	ON_WM_PAINT()
END_MESSAGE_MAP()

BOOL CDialogCritical::OnInitDialog()
{
	CDialog::OnInitDialog();

	CStatic * piconrect = (CStatic *) GetDlgItem(IDC_ICONRECT);
	CStatic * ptestorect= (CStatic *) GetDlgItem(IDC_TESTORECT);
	CStatic * ptestorect2= (CStatic *) GetDlgItem(IDC_TESTORECT2);
	CStatic * ptestorect3= (CStatic *) GetDlgItem(IDC_TESTORECT3);

	piconrect->GetWindowRect(&m_ricon);
	ptestorect->GetWindowRect(&m_rtesto);
	ptestorect2->GetWindowRect(&m_rtesto2);
	ptestorect3->GetWindowRect(&m_rtesto3);

	piconrect->DestroyWindow();
	ptestorect->DestroyWindow();
	ptestorect2->DestroyWindow();
	ptestorect3->DestroyWindow();

	ScreenToClient (&m_ricon);
	ScreenToClient (&m_rtesto);
	ScreenToClient (&m_rtesto2);
	ScreenToClient (&m_rtesto3);

	return TRUE;
}

void CDialogCritical::OnPaint()
{
	CPaintDC dc (this);
	int range = IDI_CRITICAL20-IDI_CRITICAL1+1;

	HICON hIcon = AfxGetApp()->LoadIcon(IDI_CRITICAL1+(rand()%range));

	if (hIcon !=NULL)
	{
		CDC dcMem;
		dcMem.CreateCompatibleDC (&dc);

		CBitmap bitmap;
		bitmap.CreateCompatibleBitmap (&dc, 32, 32);
		CBitmap* pOldBitmap = dcMem.SelectObject (&bitmap);

		CBrush brush (::GetSysColor (COLOR_3DFACE));
		dcMem.FillRect (CRect (0, 0, 32, 32), &brush);
		dcMem.DrawIcon (0, 0, hIcon);

		dc.StretchBlt (m_ricon.left, m_ricon.top, m_ricon.Width(),
			m_ricon.Height (), &dcMem, 0, 0, 32, 32, SRCCOPY);

		dcMem.SelectObject (pOldBitmap);
	}

	TEXTMETRIC tm;
	dc.GetTextMetrics(&tm);

	CFont FontBolt;

	int nHeight = -((dc.GetDeviceCaps (LOGPIXELSY) * tm.tmAscent) / 72);

	FontBolt.CreateFont (nHeight, 0, 0, 0, FW_BOLD,
		0, 0, 0, DEFAULT_CHARSET, OUT_CHARACTER_PRECIS,
		CLIP_CHARACTER_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH |
		FF_DONTCARE, "Times New Roman");

	CFont Font;
	nHeight = -((dc.GetDeviceCaps (LOGPIXELSY) * 10) / 72);

	Font.CreateFont (nHeight, 0, 0, 0, FW_NORMAL,
		0, 0, 0, DEFAULT_CHARSET, OUT_CHARACTER_PRECIS,
		CLIP_CHARACTER_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH |
		FF_DONTCARE, "Arial");

	dc.SetBkColor((COLORREF) ::GetSysColor(COLOR_3DFACE));

	CFont* pOldFont = dc.SelectObject (&FontBolt);

	dc.ExtTextOut (m_rtesto.left, m_rtesto.top, ETO_CLIPPED, m_rtesto, m_riga1, NULL);

	dc.SelectObject(&Font);
	dc.ExtTextOut (m_rtesto2.left, m_rtesto2.top, ETO_CLIPPED, m_rtesto2, m_riga2, NULL);
	dc.DrawText (m_riga3, m_rtesto3, DT_WORDBREAK);

	dc.SelectObject (pOldFont);
}