// File Tables.cpp
// Contiene la descrizione delle funzione membro delle classi di tools.h

// File Header per CSingleTable
#include <afx.h>
#include <afxcoll.h>

// Definizione funzioni membro di CSingle Table

//Funzioni private
CSingleTable * CSingleTable::NewTail()
{
	if (m_NextItem!=NULL)
		return m_NextItem->NewTail();
	m_NextItem=new CSingleTable;
	return m_NextItem;
}


// Definizione funzioni membro di CMultiTable

// funzioni private
CMultiTable::CMultiTable()
{
	m_TopList=NULL;
	m_TempList=NULL;
	m_TempTable=NULL;
	m_Row=0;
	m_Column=0;
}

CStringArray * CMultiTable::GetTable(int tipo, int lingua)
{
	if (m_TopList==NULL)
		return NULL;
	int pos=tipo*(m_Column)+lingua;
	if (pos>= m_Row*m_Column)
		return NULL;

	m_TempList=m_TopList;
	while (pos-->0)
		m_TempList=m_TempList->NextTable();
	return m_TempList->AccessTable();
}

void CMultiTable::Init(int lingue)
{
	if (m_TopList!=NULL)
	{
		delete m_TopList;
		m_TopList=NULL;
		m_TempList=NULL;
		m_TempTable=NULL;
		m_Row=0;
	}
	m_Column=lingue;
}

int CMultiTable::NextItem(CString obj)
{
	if (m_TopList==NULL || m_TempTable==NULL)
		return -1;
	return m_TempTable->Add((LPCTSTR) obj);
}

BOOL CMultiTable::NewTable()
{
	static int NChiamate=1;
	if (m_TopList==NULL)
	{
		m_TopList=new CSingleTable;
		m_TempList=m_TopList;
		m_TempTable=m_TempList->AccessTable();
		m_Row=1;
		return TRUE;
	}
	
	if (m_TempList==NULL)
		return FALSE;
	
	m_TempList=m_TempList->NewTail();
	m_TempTable=m_TempList->AccessTable();
	NChiamate++;
	if (NChiamate>m_Column)
	{
		NChiamate=1;
		m_Row++;
	}
	return TRUE;
}

BOOL CMultiTable::SetTable(int caster, int language)
{
	if (m_TopList==NULL)
		return FALSE;
	int pos = caster*(m_Column+1)+language;
	if (pos >= m_Row*m_Column)
		return FALSE;

	m_TempList=m_TopList;
	while(pos-->0)
		m_TempList=m_TempList->NextTable();
	m_TempTable=m_TempList->AccessTable();
	return TRUE;
}

CString CMultiTable::GetItem(int pos)
{
	if (m_TopList==NULL || m_TempTable==NULL)
		return "";
	return m_TempTable->GetAt(pos);
}

CString CMultiTable::operator[](int pos)
{
	return m_TempTable->GetAt(pos);
}

int CMultiTable::GetMaxElem()
{
	int max, tmp;
	
	if(SetTable(0, 0))
	{
		max=m_TempTable->GetSize();
		for (int cont=1; cont< m_Row; cont++)
		{
			SetTable(cont, 0);
			tmp=m_TempTable->GetSize();
			if(tmp>max)
				max=tmp;
		}
		return max;
	}

	return 0;
}

int CMultiTable::IsInTable(CString stringa)
{
	if(m_TempTable!=NULL)
	{
		for(int cont=0; cont<m_TempTable->GetSize(); cont++)
			if(m_TempTable->GetAt(cont)==stringa)
				return cont;
	}
	return -1;
}

int CMultiTable::GetNumberLanguage()
{
	return m_Row;
}

// Funzioni membro di CInitSpell
CInitSpell::CInitSpell()
{
	if (!m_File.Open("fantasy.cfg", CFile::modeRead))
	{
		MessageBox(NULL,"Errore Applicazione: file di configurazione non trovato. Impossibile continuare.","ERROR!!", MB_OK);
		m_Error=TRUE;
		return;
	}
	m_Error=FALSE;
}

BOOL CInitSpell::InitStruct(CStringArray & Caster, CMultiTable & School)
{
	if (m_Error)
		return FALSE;

	if (!FileSearch("[New Caster]"))
		return FALSE;

	CString riga;
	BOOL noexit=TRUE;

	// Immissione dati Caster standard
	if (AfxGetApp()->GetProfileInt("Default Caster","Wizard", 0))
		Caster.Add("Wizard");

	if (AfxGetApp()->GetProfileInt("Default Caster","Priest", 0))
		Caster.Add("Priest");

	// Immissione dati x nuovi caster
	while(noexit)
	{
		noexit=GetString(riga);
		if (riga=="")
			break;
		Caster.Add(riga);
	}

	if (Caster.GetSize()==0)
	{
		::MessageBox(NULL, "Non sono stati rilevati identificativi di caster", "ERROR Found - Fantasy.cfg",MB_OK);
		return FALSE;
	}

	// Immissione dati per school/sphear
	if (!FileSearch("["+Caster[0]+"]"))
		return FALSE;

	// Ricerca numero di lingue
	int ling=0;
	while (GetString(riga))
	{
		if (riga=="")
			break;
		if (riga[0]=='>')
			ling++;
	}

	// Inserimento nome scuole ad ogni caster
	if (ling==0)
	{
		::MessageBox(NULL, "Errore nel file di configurazione 'Fantasy.cfg': Non posso identificare i nominativi delle scuole", "ERROR Found", MB_OK);
		return FALSE;
	}

	int Max=Caster.GetSize();

	School.Init(ling);
	for (int cont=0; cont<Max; cont++)
	{
		if (!FileSearch("["+Caster[cont]+"]"))
			return FALSE;

		noexit=GetString(riga);
		while(noexit && riga!="")
		{
			if (riga[0]=='>')
			{
				School.NewTable();
				riga=riga.Right(riga.GetLength()-1);
				School.NextItem(riga);
			}
			else
				School.NextItem(riga);
			noexit=GetString(riga);
		}
	}
	return TRUE;
}

BOOL CInitSpell::FileSearch(CString descr)
{
	if (m_Error)
		return FALSE;

	CString riga;
	m_File.SeekToBegin();
	while(m_File.ReadString(riga) && riga!=descr);
	if (riga==descr)
		return TRUE;
	MessageBox(NULL, "Caratteristiche non trovate!!","INIZIALIZZATION ERROR!", MB_OK);
	return FALSE;
}

BOOL CInitSpell::GetString(CString &stringa)
{
	BOOL val;
	do
	{
		val=m_File.ReadString(stringa);
	}
	while(val&&stringa.Find(';')==0);
		return val;
}