// File: TableCH.cpp
// definizione membri di TableOfCritical per colpi critici

#include <afx.h>
#include <stdlib.h>
#include "TableCH.h"
#include "resource.h"

// membri privati

void CTableOfCritical::PositionFile(int pos)
{
	CString tmp;

	while(pos--)
		m_File.ReadString(tmp);
}

// membri pubblici

CTableOfCritical::CTableOfCritical()
{
	m_Error=FALSE;
	// Tabella di associazione bersaglio x tipo arma => tabella rispettiva danni
	m_TableofCritical[0][0]= BLUD_VS_HUMAN;
	m_TableofCritical[0][1]= BLUD_VS_ANIMAL;
	m_TableofCritical[0][2]= BLUD_VS_MONST;
	m_TableofCritical[1][0]= SLAS_VS_HUMAN;
	m_TableofCritical[1][1]= SLAS_VS_ANIMAL;
	m_TableofCritical[1][2]= SLAS_VS_MONST;
	m_TableofCritical[2][0]= PIERC_VS_HUMAN;
	m_TableofCritical[2][1]= PIERC_VS_ANIMAL;
	m_TableofCritical[2][2]= PIERC_VS_MONST;

	// Tabella delle locazioni
	m_TableofLocation[0]= LEGS;
	m_TableofLocation[1]= LEGS;
	m_TableofLocation[2]= LEGS;
	m_TableofLocation[3]= LEGS;
	m_TableofLocation[4]= ADBOMEN;
	m_TableofLocation[5]= TORSO;
	m_TableofLocation[6]= TORSO;
	m_TableofLocation[7]= ARMS;
	m_TableofLocation[8]= ARMS;
	m_TableofLocation[9]= HEAD;

	// Inizializzazione della tabella TableofLocationList
	// Target x Locazione
	m_TableofLocationList[0][0]=IDS_LOCATION_D1;
	m_TableofLocationList[0][1]=IDS_LOCATION_D1;
	m_TableofLocationList[0][2]=IDS_LOCATION_D2;
	m_TableofLocationList[0][3]=IDS_LOCATION_D2;
	m_TableofLocationList[0][4]=IDS_LOCATION_D3;
	m_TableofLocationList[0][5]=IDS_LOCATION_D4;
	m_TableofLocationList[0][6]=IDS_LOCATION_D4;
	m_TableofLocationList[0][7]=IDS_LOCATION_D5;
	m_TableofLocationList[0][8]=IDS_LOCATION_D6;
	m_TableofLocationList[0][9]=IDS_LOCATION_D7;

	m_TableofLocationList[1][0]=IDS_LOCATION_D8;
	m_TableofLocationList[1][1]=IDS_LOCATION_D9;
	m_TableofLocationList[1][2]=IDS_LOCATION_D10;
	m_TableofLocationList[1][3]=IDS_LOCATION_D11;
	m_TableofLocationList[1][4]=IDS_LOCATION_D12;
	m_TableofLocationList[1][5]=IDS_LOCATION_D3;
	m_TableofLocationList[1][6]=IDS_LOCATION_D3;
	m_TableofLocationList[1][7]=IDS_LOCATION_D4;
	m_TableofLocationList[1][8]=IDS_LOCATION_D4;
	m_TableofLocationList[1][9]=IDS_LOCATION_D7;

	m_TableofLocationList[2][0]=IDS_LOCATION_D13;
	m_TableofLocationList[2][1]=IDS_LOCATION_D14;
	m_TableofLocationList[2][2]=IDS_LOCATION_D10;
	m_TableofLocationList[2][3]=IDS_LOCATION_D11;
	m_TableofLocationList[2][4]=IDS_LOCATION_D12;
	m_TableofLocationList[2][5]=IDS_LOCATION_D3;
	m_TableofLocationList[2][6]=IDS_LOCATION_D3;
	m_TableofLocationList[2][7]=IDS_LOCATION_D4;
	m_TableofLocationList[2][8]=IDS_LOCATION_D4;
	m_TableofLocationList[2][9]=IDS_LOCATION_D7;

	if(!m_File.Open("CriticalHit.cfg", CFile::modeRead))
	{
		::MessageBox(NULL, "File <CriticalHit.cfg> not found.\n Assuming no critical.", "Error", MB_OK|MB_ICONERROR);
		m_Error=TRUE;
	}

}

CTableOfCritical::GetTable(int WeaponType, int Target)
{
	if(WeaponType<0 || WeaponType>3 || Target<0 || Target >3)
		return m_TableofCritical[0][0];

	return m_TableofCritical[WeaponType][Target];
}

CTableOfCritical::GetLocation(int location)
{
	if(location<0 || location>10)
		return m_TableofLocation[0];

	return m_TableofLocation[location];
}

CTableOfCritical::GetLocationDamage(int target, int locazione)
{
	if(target<0 || target>3 || locazione<0 || locazione>10)
		return m_TableofLocationList[0][0];

	return m_TableofLocationList[target][locazione];
}

CString CTableOfCritical::GetDamage(int table, int locaz, int danno)
{
	// danno varia tra 1-11
	/* il file  composto da 9 tabelle ognuna delle quali  composta
	da 5 locazioni danni. Ogni locazioni danni ha 10 descrittori.
	il formato  il seguente:
	<tabella>
	<>
	<locazione>
	{10 righe}
	<>
	<locazione>
	.....
	<>
	<tabella>
	<>
	<locazione>
	{10 righe}
	....

	danno indica l'offset dalla locazione (togliere 1)

	locazione  l'offset dalla tabella:
	locazione 1 -> + 3 r					+ 3 r			= base
	locazione 2 -> +10 +2 +3 r				+12*(locaz-1) + base
	locazione 3 -> +10 +2 +10 +2 +3 r		+12*(locaz-1) + base
	...
	locazione 5 -> .....					+51 riga

	tabella :
	tabella 1 -> 0 riga
	tabella 0 -> 51 r + 10 +1				([locazione=5]+11)*(tabella-1)
											*/

	if(table<0 || table>9 || locaz<0 || locaz>4 || danno<0 ||danno>10 || m_Error)
		return "";

	CString tmp;

	int pos;
	
	//calcolo posizione tabella
	pos=62*table;

	//calcolo offset locazione
	pos+= 12*locaz+3;

	//calcolo offset danno
	pos+=danno-1;
	
	PositionFile(pos);

	m_File.ReadString(tmp);

	// debuggin
#ifdef _DEBUG
	CString strdebug;
	char cdebug[10];
	strdebug="Tabella considerata = ";
	strdebug+=_itoa(table, cdebug, 10);

	strdebug+="\nLocazione considerata = ";
	strdebug+=_itoa(locaz, cdebug, 10);

	strdebug+="\nDanno considerata = ";
	strdebug+=_itoa(danno, cdebug, 10);

	strdebug+="\n\nStringa prelevata = "+tmp;

	::MessageBox(NULL, strdebug, "DEBUG Info", MB_OK|MB_ICONINFORMATION);
#endif

	return tmp;
}