// File: Main.cpp
// File principale

#include <afxwin.h>
#include <vfw.h> // to cancel
#include <string.h>
#include "resource.h"
#include "roll.h"
#include "spell1.h"
#include "CSpellBook.h"
#include "about.h"
#include "main.h"

#define WM_NOTIFYICONPROGRAM	(WM_USER+100)

CMyApp myApp;

// Definizione membri di CMyApp
CMyApp::InitInstance()
{
	m_pMainWnd = new CMainWindow;
	m_pMainWnd->ShowWindow(m_nCmdShow);
	m_pMainWnd->UpdateWindow();
	SetRegistryKey("LCS Groups");

	nid.hWnd=m_pMainWnd->m_hWnd;
	nid.uID=2000;
	nid.uFlags=NIF_TIP|NIF_ICON|NIF_MESSAGE;
	nid.uCallbackMessage=WM_NOTIFYICONPROGRAM;
	nid.hIcon=LoadIcon(IDI_CRITICAL16);
	strcpy(nid.szTip,"Fantasy Tools");
	nid.cbSize=sizeof(nid);
	::Shell_NotifyIcon(NIM_ADD,&nid );

	return TRUE;
}

CMyApp::ExitInstance()
{
	int ret= ::Shell_NotifyIcon(NIM_DELETE, &nid);

	return !ret;
}


// Definizione membri di CMainWindow

BEGIN_MESSAGE_MAP( CMainWindow, CWnd)
	ON_WM_ERASEBKGND()
	ON_WM_CREATE()
	ON_COMMAND(IDM_TOOLEXIT, OnExit)
	ON_COMMAND(IDM_TOOLSDICE, OnDiceRoll)
	ON_COMMAND(IDM_TOOLSPELL, OnSpell)
	ON_COMMAND(IDM_TOOLBOOK, OnBook)
	ON_COMMAND(IDM_ABOUT, OnAbout)
	ON_COMMAND(IDM_OPTION, OnOption)
	ON_COMMAND( ID_HELP_FINDER, OnHelpFinder )	// richiama HELP
	ON_MESSAGE(WM_NOTIFYICONPROGRAM, OnStatusBar)
	ON_MESSAGE(WM_USERADDBOOK, OnAddSpell)
	ON_MESSAGE(WM_USERBOOKVIEWSPELL, OnViewSpellFromBook)
	ON_MESSAGE(WM_USERSBOOKTOADD, OnMakeViewSpellFromBook)
END_MESSAGE_MAP()

//Funzione di inizializzazione:costruttore - create - delete this
CMainWindow::CMainWindow()
{
	CString strWndClass=AfxRegisterWndClass(0, myApp.LoadStandardCursor(IDC_ARROW),
												(HBRUSH) (COLOR_3DFACE+1),
												myApp.LoadIcon(ID_ICON1));
	CMenu menu;
	menu.LoadMenu(IDR_MENU1);
	CreateEx(WS_EX_CLIENTEDGE, strWndClass, "Fantasy - Tools for Ad&d", WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX,
				CW_USEDEFAULT, CW_USEDEFAULT,CW_USEDEFAULT, CW_USEDEFAULT,
				NULL, menu.Detach());

	CRect rect (0, 0, m_bm.bmWidth, m_bm.bmHeight);
	CalcWindowRect(&rect);

	SetWindowPos(NULL, 50, 50, rect.Width(), rect.Height(), SWP_SHOWWINDOW);
}

int CMainWindow::OnCreate(LPCREATESTRUCT lpcs)
{
	if(CWnd::OnCreate(lpcs)==-1)
		return -1;

	m_bitmap.LoadBitmap (IDB_BITMAP1);
	m_bitmap.GetObject (sizeof (m_bm), &m_bm);
	m_Roll=NULL;
	m_Spell=NULL;
	m_SpellBook=NULL;

	return 0;
}

void CMainWindow::PostNcDestroy()
{
	delete this;
}

//Definizione funzioni di catch messaggi

BOOL CMainWindow::OnEraseBkgnd(CDC * pCdc)
{
	CDC dcMem;
	dcMem.CreateCompatibleDC (pCdc);
	CBitmap* pOldBitmap = dcMem.SelectObject (&m_bitmap);
	pCdc->BitBlt (0, 0, m_bm.bmWidth, m_bm.bmHeight, &dcMem, 0, 0, SRCCOPY);
	dcMem.SelectObject (pOldBitmap);

	return TRUE;
}

//Definizione funzioni collegamento memu

void CMainWindow::OnDiceRoll()
{
	if (m_Roll != NULL)
	{
		m_Roll->ShowWindow(SW_RESTORE);
		m_Roll->SetFocus();
		return;
	}
	m_Roll = new CRollDice;

}

void CMainWindow::OnSpell()
{
	if (m_Spell != NULL)
	{
		m_Spell->ShowWindow(SW_RESTORE);
		m_Spell->SetFocus();
		return;
	}
	m_Spell= new CSpellView;
}

void CMainWindow::OnBook()
{
	if (m_SpellBook != NULL)
	{
		m_SpellBook->ShowWindow(SW_RESTORE);
		m_SpellBook->SetFocus();
		return;
	}
	m_SpellBook= new CSpellBook;
}

void CMainWindow::OnExit()
{
	SendMessage(WM_CLOSE, 0, 0);
}

void CMainWindow::OnAbout()
{
	CDialogAbout Dlg (this);
	Dlg.DoModal();
}

void CMainWindow::OnOption()
{
	MessageBox("Per impostare le opzioni dei rispettivi tools\n utilizzare il menu di contesto (tasto destro del mouse), ove presente.","Help on Option");
}

void CMainWindow::OnStatusBar(UINT prova, LONG prova2)
{
	switch(prova2)
	{
	case WM_LBUTTONDOWN: ShowWindow(SW_RESTORE);
						break;
	case WM_LBUTTONDBLCLK: MessageBox("Not yet ready!!!", "Buona giornata a tutti");
						break;
	}
}

void CMainWindow::OnAddSpell(UINT wparam, long lparam)
{
	DEFSPELL * pSpell=(DEFSPELL *) lparam;
	OnBook();
	m_SpellBook->AddSpell(*pSpell);
}

void CMainWindow::OnViewSpellFromBook(UINT wparam, long lparam)
{
	OnSpell();
	::SendMessage(m_Spell->m_hWnd, WM_USERSPELL, 0, (LPARAM) lparam);
}


void CMainWindow::OnMakeViewSpellFromBook(UINT wparam, long lparam)
{
	MessageBox("Pippo!!!!","Pippppppppo!!!!!!!");
//	OnSpell();
//	::SendMessage(m_Spell->m_hWnd, WM_USERSPELL, 0, (LPARAM) lparam);
}