// File CGroupSpell.cpp

#include <afx.h>
#include "resource.h"
#include "spell1.h"
#include "CGroupSpell.h"

IMPLEMENT_SERIAL(CGroupSpell, CObject,1)


CGroupSpell::CGroupSpell(CString cast, CString lev)
{
	if (!cast.IsEmpty() && !lev.IsEmpty())
	{
		m_Caster=cast;
		m_Level=lev;
	}
}


void CGroupSpell::PutSpell(DEFSPELL * pSpell)
{
	if (m_Caster.Compare(pSpell->Caster)!=0 && m_Level.Compare(pSpell->Level)!=0)
		return;
	for (int i=0; i<m_Name.GetSize(); i++)
	{
		CString tmp=(CString) m_Name.GetAt(i);
		if (tmp.Compare(pSpell->Name)>=0)
			break;
	}
	m_Name.InsertAt(i,pSpell->Name);
}


void CGroupSpell::Serialize(CArchive &ar)
{
	CObject::Serialize(ar);

	if(ar.IsStoring())
	{
		ar << m_Caster;
		ar << m_Level;
	}
	else
	{
		ar >> m_Caster;
		ar >> m_Level;
	}
	m_Name.Serialize(ar);
}