// file CFormatBook.cpp
#include <afx.h>
#include "CFormatBook.h"

// definizione membri privati

// definizioni membri pubblici

// si occupa di inizializzare il testo con le caratteristiche specifiche dell tipo di testo da trattare
void CFormatBook::Init(int type, int mode)
{
	m_iType=type;

	if (mode==RESET_STR)
		m_strTesto="";
	else if (m_iType==RTF)
	{
		// definizione file RTF
		m_strTesto="{\\rtf1\\ansi";

		// inserimento font table
		// per ora il testo  fisso
		// definizione font default
		m_strTesto+="\\deff1";
		//definizione tabella font
		m_strTesto+="{\\fonttbl {\\f1\\fswiss\\fcharset0\\fprq2{\\*\\panose 020b0604020202020204}Arial;}{\\f2\\fmodern\\fcharset0\\fprq1{\\*\\panose 02070309020205020404}Courier New;} {\\f70\\fnil\\fcharset0\\fprq2{\\*\\panose 00000400000000000000}Blood Of Dracula;} {\\f137\\fnil\\fcharset0\\fprq2{\\*\\panose 01010101010101010101}Mercurius Script MT Bold;} {\\f137\\fs24\\cf16\\cgrid0 \\'ae}{\\f240\\fmodern\\fcharset238\\fprq1 Courier New CE;} }";
		// termine definizione font default
		m_strTesto+="\\fs18";
		//definizione documento con due colonne
		m_strTesto+="\\linex0\\headery709\\footery709\\cols2\\colsx200\\endnhere\\sectdefaultcl";
	}
	else if (m_iType==HTML)
	{
		m_strTesto="<html>";
	}
}


// termina la sessione
void CFormatBook::End(int session)
{
	// abilita chiusura TAG o fine sessione (non ancora attivato)
	if (m_iType==RTF)
	{
		m_strTesto+="}";
	}
	else if (m_iType==HTML)
	{
		m_strTesto+="</BODY></HTML>";
	}
}


void CFormatBook::SetHeader(CString header)
{
	// provvisiorio. da potenziare con tipologia di font etc.
	if (m_iType==RTF && !header.IsEmpty())
	{
		m_strTesto+="{\\header \\pard\\plain \\s16\\li5664\\nowidctlpar\\widctlpar\\tqc\\tx4819\\tqr\\tx9638\\adjustright \\f1\\fs18\\lang1040\\cgrid {\\f70\\fs28\\cf16\\lang1033 ";
		m_strTesto+=header;
		m_strTesto+="}{\\f137\\fs24\\cf16\\cgrid0 \\'ae}{\\field{\\*\\fldinst {\\cs18  PAGE }}{\\fldrslt {\\cs18\\lang1024 iii}}} di {\\field{\\*\\fldinst {\\cs18  NUMPAGES }}{\\fldrslt {\\cs18\\lang1024 iii}}}{\\f70\\fs28\\cf16\\lang1033 \\par }}";
	}
	else if (m_iType==HTML && !header.IsEmpty())
	{
		m_strTesto+="<TITLE>";
		m_strTesto+=header;
		m_strTesto+="</TITLE>";
	}
}


void CFormatBook::WriteItalic(CString row,int cr)
{
	if (m_iType==RTF)
	{
		m_strTesto+="{\\i ";
		m_strTesto+=row;
		m_strTesto+=" }";
		if (cr==CR)
			m_strTesto+="\\par ";
	}
	else if (m_iType==HTML)
	{
		m_strTesto+="<I>";
		m_strTesto+=row;
		m_strTesto+="</I>";
		if (cr==CR)
			m_strTesto+="<BR>";
	}
}


void CFormatBook::WriteBolt(CString row,int cr)
{
	if (m_iType==RTF)
	{
		m_strTesto+="{\\b ";
		m_strTesto+=row;
		m_strTesto+="}";
		if (cr==CR)
			m_strTesto+="\\par ";
	}
	else if (m_iType==HTML)
	{
		m_strTesto+="<B>";
		m_strTesto+=row;
		m_strTesto+="</B>";
		if (cr==CR)
			m_strTesto+="<BR>";
	}
}


void CFormatBook::Write(CString row,int cr)
{
	m_strTesto+=row;
	if (m_iType==RTF && cr==CR)
	{
		m_strTesto+="\\par ";
	}
	else if (m_iType==HTML && cr==CR)
	{
		m_strTesto+="<BR>";
	}
}


// Temporanea
//scrive una stringa in dp 12 in grassetto
void CFormatBook::WriteTitle(CString row)
{
	if (m_iType==RTF)
	{
		m_strTesto+="{\\b\\fs24 ";
		m_strTesto+=row;
		m_strTesto+="}\\par\\par ";
	}
	else if (m_iType==HTML)
	{
		m_strTesto+="<H1><B>";
		m_strTesto+=row;
		m_strTesto+="</B></H1><BR>";
	}
}


// inserisce nuova pagine
void CFormatBook::InsertPage()
{
	if (m_iType==RTF)
		m_strTesto+="\\page ";
}


//restituisce la stringa formattata
CString CFormatBook::ReturnString()
{
	return m_strTesto;
}


// definizione membri protetti
